<?php

function theme_enqueue_styles() {
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'avada-stylesheet' ) );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );

function avada_lang_setup() {
	$lang = get_stylesheet_directory() . '/languages';
	load_child_theme_textdomain( 'Avada', $lang );
}
add_action( 'after_setup_theme', 'avada_lang_setup' );

// specials shortcodes
function daily_specials(){	
		$html = '';
	if( have_rows('daily_specials', 'option') ):
    while( have_rows('daily_specials', 'option') ) : the_row(); 
		$name = get_sub_field('special_name');
		$price = get_sub_field('special_price');
		$desc = get_sub_field('special_desc');
		$html.= '<div class="specials-element"><h2 style="font-weight: bolder; font-size: 24px; margin-bottom: 15px;">'.$name.'</h2><div style="font-size: 18px; margin-bottom: 10px;">'.$desc.'</div><div style="display:flex; align-items: center;" class="flex-children"><img decoding="async" style="height: 4.66px; max-width: 420px;" title="separator-light" src="https://teenafamilyrestaurant.primitiv.media/wp-content/uploads/2021/10/separator-light.png" data-orig-src="https://teenafamilyrestaurant.primitiv.media/wp-content/uploads/2021/10/separator-light.png" alt="" class="img-responsive wp-image-52 lazyloaded"><span style="color: var(--awb-color5); font-size: 22px;">$ '.$price.'/ person</span></div></div>';
    endwhile;
endif;
	
	return '<div id="specials-container">'.$html.'</div>';
}
add_shortcode( 'daily_specials', 'daily_specials' );

// soup of the day shortcodes
function soup_specials()
{
    $variable = get_field('soups', 'option');
    return '<div style="font-size: 18px; text-align: center;">' . $variable . '</div>';
}

add_shortcode('soups', 'soup_specials');